%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
function sys_state = Closed_sys_performance(t,xx,A,Delta_A,B,F,D,C,K,N,G,L,H)
[n,~] = size(B);

X = xx(1:n);
xi = xx(n+1:end);

global tmp count ts ex1 ex2 ex3 ex4 ex5 ef ff
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% disturbance and fault
d1 = 0.05*(-1+2*rand(1,1)); %random value within [-0.05, 0.05]
d2 = 0.01 * cos(0.5*t);
d = [d1;d2];

% f
if t <= 50
    f = 0;
elseif 50 < t & t <= 100
    f = 1;
elseif 100 < t & t <= 150
    f = 2;
elseif 150 < t & t <= 200
    f = 1;
elseif 200 < t
    f = 0;
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
y = C*X;
hat_Xf = xi + H*y;

% controller
Kf = -pinv(B)*F;
hat_X = hat_Xf(1:n);
hat_f = hat_Xf(n+1);

u = K*hat_X + Kf*hat_f;%FTC
% u = K*X; %baseline

%observer
dot_xi = N*xi + G*u + L*y;

% sys dynamic
Delta_At = Delta_A*sin(pi/10*t);
dot_X = (A + Delta_At)*X + B*u + F*f + D*d;

% data saving 
if mod(tmp,20)==0
    count = count + 1;
ts(count) = t;
ex1(count) = abs(X(1) - hat_Xf(1));
ex2(count) = abs(X(2) - hat_Xf(2));
ex3(count) = abs(X(3) - hat_Xf(3));
ex4(count) = abs(X(4) - hat_Xf(4));
ex5(count) = abs(X(5) - hat_Xf(5));
ef(count) = abs(f - hat_Xf(6));
ff(count) = f;
end
tmp = tmp + 1;

sys_state = [dot_X;dot_xi];